#######################################################################
#### ANOVA of environmental variables between sites ###################
#### and ANOSIM results from past -> Table 2###########################
#### Data to import: envaverage2.txt ##################################
#######################################################################
### (c) T.R. Vonnahme ###############################################
###################################################################
##################################################################

###Journal: Biogeosciences: special issue: Freshwater ecosystems in changing permafrost landscapes
###Title of the paper: Controls on microalgal community structures in cryoconite holes upon high Arctic glaciers, Svalbard

###Authors and affiliations:#######################################
#########T.R. Vonnahme1,2,*  M. Devetter1,3  J. D. rsk1,4  M. aback1,5  J. Elster1,6
#########[1] Centre for Polar Ecology, Faculty of Science, University of South Bohemia, Cesk Budejovice, Czech Republic
#########[2] University of Konstanz, Constance, Germany
#########[3] Biology Centre of the Academy of Science of the Czech Republic, Institute of Soil Biology, Cesk Budejovice, Czech Republic
#########[4] Department of Ecology, Charles University, Prague, Czech Republic
#########[5] British Antarctic Survey, Cambridge, UK
#########[6] Institute of Botany, Academy of the Science of the Czech Republic, Trebon, Czech Republic
#########[*] {now at: Max Planck Institute for Marine Microbiology, Bremen, Germany} 
#########Correspondence to: T. R. Vonnahme (t.r.vonnahme@gmail.com) 

##################################################################
###################################################################
##################################################################

setwd("E://")

############################################
###A) data import: summarized data #########
env<-read.table("envaverage2.txt", header=T)

### subset with used variables, with NAs ##############
all<-data.frame(env$ID, env$site, env$elevation, env$sedmass,
    env$water, env$om, env$depth, env$slopedist)


######################################################################
### ANOVAS environmentally different sites ###########################
######################################################################
#### test: TukeyHSD of a one-way ANOVA ###############################
#### p-value threshhold: 0.05 ########################################
#### p correction: implied by the TukeyHSD test ######################
#### model validation: Histograms for normal distribution##############
####                   Residuals vs fitted, Q-Q, Res. vx Leverage######
####                   Cook's distance, Scale-Location -> all graphical#
########################################################################

str(all)

hist(log(all$env.sedmass))
an1<-aov(log(all$env.sedmass[-45])~all$env.site[-45])
par(mfrow=c(2,2))
plot(an1)
par(mfrow=c(1,1))
TukeyHSD(an1)
### NL-HC, NL-NC different
### 45 is NR1, a cryoconite with the thickest sediment layer,
### probably accumulated in a crevasse --> removed as outlier
### indetified with Cook's distance in another model

hist((all$env.water))
an2<-aov(all$env.water[-25]~all$env.site[-25])
TukeyHSD(an2)
par(mfrow=c(2,2))
plot(an2)
par(mfrow=c(1,1))
### NL-NC different
### 25 is outlier
### 25 is NC3: the hole with the most unusual community!!!
### unusual: very high tardigrade counts, rapidly changing
### dimensions, location, sediment thickness, and community structure

hist(all$env.om[-25])
an3<-aov(all$env.om[-25]~all$env.site[-25])
TukeyHSD(an3)
par(mfrow=c(2,2))
plot(an3)
par(mfrow=c(1,1))
### NC-E, NC-HC, NL-NC, NL-NI all different 

hist(sqrt(all$env.depth))
an4<-aov(sqrt(all$env.depth)~all$env.site)
TukeyHSD(an4)
par(mfrow=c(2,2))
plot(an4)
par(mfrow=c(1,1))
### HC-E, NI-HC***, NL-HC, NI-NC, NR-NI different

### following variables are obviously different!!!
### but do not have a biological meaning
an5<-aov(all$env.slopedist~all$env.site)
TukeyHSD(an5)
an6<-aov(all$env.elevation~all$env.site)
TukeyHSD(an6)

################################################################
### ANOSIM #####################################################
### For community structure with ANOSIM -> program past#########
#### test: ANOSIM with past, one-way, Bray-curtis, 9999perm ####
#### p value threshhold: 0.05 ##################################
#### p correction: false discovery rate ########################
################################################################

################################################################################
### 1: differences between microalgae between sites (Bray-Curtis, one way ANOSIM)
###uncorrected p values (created by past)9999perm###############################

#0	E1	HC1	NC1	NI1	NL1	NR1
#E1	0	0.0023	0.3763	0.0908	0.6029	0.003
#HC1	0.0023	0	0.0001	0.0001	0.0001	0.0001
#NC1	0.3763	0.0001	0	0.0223	0.069	0.0041
#NI1	0.0908	0.0001	0.0223	0	0.2621	0.0024
#NL1	0.6029	0.0001	0.069	0.2621	0	0.0065
#NR1	0.003	0.0001	0.0041	0.0024	0.0065	0

p<-c(0.0023,	0.3763,	0.0908,	0.6029,	0.003,
0.0001,	0.0001,	0.0001,	0.0001,
0.0223,	0.069,	0.0041,
0.2621,	0.0024,
0.0065)

# p correction after false discovery rate
pcor2<-p.adjust(p, method="fdr", n=15)
pcor2

#[1] 0.006000000* 0.403178571 0.113500000 0.602900000 0.006428571* 0.000375000*
#[7] 0.000375000* 0.000375000* 0.000375000* 0.033450000* 0.094090909 0.007687500*
#[13] 0.302423077 0.006000000* 0.010833333*

#R values (by past)
#0	E1	HC1	NC1	NI1	NL1	NR1
#E1	0	0.4789*	0.01722	0.1519	-0.05	0.4747*
#HC1	0.4789	0	0.427*	0.9137*	0.8204*	0.8073*
#NC1	0.01722	0.427	0	0.2639*	0.1811	0.5018*
#NI1	0.1519	0.9137	0.2639	0	0.05556	0.6347*
#NL1	-0.05	0.8204	0.1811	0.05556	0	0.5147*
#NR1	0.4747	0.8073	0.5018	0.6347	0.5147	0
###Differences between: E-HC,NR  HC-NC,NI,NL,NR   NC-NI,NR    NI,NL-NR

#################################################################################
###2: differences between invertebrates between sites (Bray-Curtis, one-way ANOSIM
### uncorrected p values (created by past)9999perm.
#0	E1	HC1	NC1	NI1	NL1	NR1
#E1	0	0.0344	0.0466	0.0064	0.0117	0.0129
#HC1	0.0344	0	0.4676	0.2005	0.012	0.6525
#NC1	0.0466	0.4676	0	0.6223	0.0211	0.8701
#NI1	0.0064	0.2005	0.6223	0	0.3635	0.9934
#NL1	0.0117	0.012	0.0211	0.3635	0	0.2433
#NR1	0.0129	0.6525	0.8701	0.9934	0.2433	0

p<-c(0.0344,	0.0466,	0.0064,	0.0117,	0.0129,
0.4676,	0.2005,	0.012,	0.6525,
0.6223,	0.0211,	0.8701,
0.3635,	0.9934,
0.2433)

pcor2<-p.adjust(p, method="fdr", n=15)
pcor2
# [1] 0.08600000 0.09985714 0.04837500* 0.04837500* 0.04837500* 0.63763636
#[7] 0.37593750 0.04837500* 0.75288462 0.75288462 0.06330000 0.93225000
#[13] 0.54525000 0.99340000 0.40550000

#R values (by past)(stars for sign adj p values)
#0	E1	HC1	NC1	NI1	NL1	NR1
#E1	0	0.2647	0.2133	0.5093*	0.2889*	0.4907*
#HC1	0.2647	0	-0.004659	0.1117	0.3866*	-0.07346
#NC1	0.2133	-0.004659	0	-0.04889	0.2628	-0.1411
#NI1	0.5093	0.1117	-0.04889	0	0.0213	-0.1947
#NL1	0.2889	0.3866	0.2628	0.0213	0	0.05733
#NR1	0.4907	-0.07346	-0.1411	-0.1947	0.05733	0
### Differences between: E-NI,NL,NR   HC-NL   


###############################################################################
### 3 seasonal variation algae ################################################

### p values
#0	HC1.2	HC1.3	HC1.4
#HC1.2	0	0.9589	0.3555
#HC1.3	0.9589	0	0.8589
#HC1.4	0.3555	0.8589	0

### p values
#0	NC2.1	NC9.2	NC1.3	NC1.4
#NC2.1	0	0.0077	0.2432	0.8553
#NC9.2	0.0077	0	0.2429	0.2654
#NC1.3	0.2432	0.2429	0	0.1395
#NC1.4	0.8553	0.2654	0.1395	0

pn<-c(0.0077,	0.2432,	0.8553,
0.2429,	0.2654,
0.1395)
ph<-c(0.9589,	0.3555, 0.8589)
pt<-c(pn,ph)
pcor3<-p.adjust(pt, method="fdr", n=9)
pcor3

#[1] 0.06930 0.47772 0.95890 0.47772 0.47772 0.47772 0.95890 0.53325 0.95890

##############################################################################
###4 seasonal variation grazer ###############################################

# p-values
#0	HC1.2	HC4.3	HC1.4
#HC1.2	0	0.6019	0.6662
#HC4.3	0.6019	0	0.9539
#HC1.4	0.6662	0.9539	0

#0	NC3.1	NC1.2	NC1.3	NC1.4
#NC3.1	0	0.1841	0.2239	0.1901
#NC1.2	0.1841	0	0.62	0.7975
#NC1.3	0.2239	0.62	0	0.2854
#NC1.4	0.1901	0.7975	0.2854	0

###all unadjusted p values above 0.05

##########################################################################
### RESULTS ##############################################################
### - no seasonal variation
### E   HC    NC   NI   NL   NR
##E +   A     G    G    G    A
#HC -   +     A    A    AG   A
#NC -   -     +    A    -    A
#NI -   -     -    +    -    A
#NL -   -     -    -    +    A
#NR -   -     -    -    -    +
### A: algal community is different, G: Grazer community is different   
